/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class MedianFilter
extends WholeImageFilter {
    private int median(int[] array) {
        int max2;
        int i;
        for (i = 0; i < 4; ++i) {
            max2 = 0;
            int maxIndex = 0;
            for (int j = 0; j < 9; ++j) {
                if (array[j] <= max2) continue;
                max2 = array[j];
                maxIndex = j;
            }
            array[maxIndex] = 0;
        }
        max2 = 0;
        for (i = 0; i < 9; ++i) {
            if (array[i] <= max2) continue;
            max2 = array[i];
        }
        return max2;
    }

    private int rgbMedian(int[] r, int[] g2, int[] b) {
        int index = 0;
        int min2 = Integer.MAX_VALUE;
        for (int i = 0; i < 9; ++i) {
            int sum = 0;
            for (int j = 0; j < 9; ++j) {
                sum += Math.abs(r[i] - r[j]);
                sum += Math.abs(g2[i] - g2[j]);
                sum += Math.abs(b[i] - b[j]);
            }
            if (sum >= min2) continue;
            min2 = sum;
            index = i;
        }
        return index;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        int[] argb = new int[9];
        int[] r = new int[9];
        int[] g2 = new int[9];
        int[] b = new int[9];
        int[] outPixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int k = 0;
                for (int dy = -1; dy <= 1; ++dy) {
                    int iy = y + dy;
                    if (0 > iy || iy >= height) continue;
                    int ioffset = iy * width;
                    for (int dx = -1; dx <= 1; ++dx) {
                        int rgb;
                        int ix = x + dx;
                        if (0 > ix || ix >= width) continue;
                        argb[k] = rgb = inPixels[ioffset + ix];
                        r[k] = rgb >> 16 & 0xFF;
                        g2[k] = rgb >> 8 & 0xFF;
                        b[k] = rgb & 0xFF;
                        ++k;
                    }
                }
                while (k < 9) {
                    argb[k] = -16777216;
                    b[k] = 0;
                    g2[k] = 0;
                    r[k] = 0;
                    ++k;
                }
                outPixels[index++] = argb[this.rgbMedian(r, g2, b)];
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Blur/Median";
    }
}

